/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.exprcomp;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWGuid;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.ConvertOp;
import filenet.vw.base.exprcomp.DoubleLitOp;
import filenet.vw.base.exprcomp.GotoOp;
import filenet.vw.base.exprcomp.IField;
import filenet.vw.base.exprcomp.IFieldCollection;
import filenet.vw.base.exprcomp.IdentOp;
import filenet.vw.base.exprcomp.IfOp;
import filenet.vw.base.exprcomp.Lexer;
import filenet.vw.base.exprcomp.MiscellaneousOp;
import filenet.vw.base.exprcomp.NumberLitOp;
import filenet.vw.base.exprcomp.OpCode;
import filenet.vw.base.exprcomp.PropertyOp;
import filenet.vw.base.exprcomp.StringLitOp;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import java.util.ArrayList;
import java.util.Hashtable;

class VWExprEmit {
    Lexer myLexer;
    IFieldCollection theFields = null;
    IFieldCollection theInheritedFields = null;
    IFieldCollection theAltFields = null;
    IFieldCollection theAltInheritedFields = null;
    VWCompiledExpr compExpr = null;
    IField lastEmittedIdentifierFD = null;
    boolean bBadIdentToken = false;
    int theResultDataType;
    boolean theResultIsArray = false;
    int expectedFieldType = -1;
    boolean bGotError = false;
    boolean bAlreadyGotBadOperand = false;
    boolean tempResultType;
    int theSubScriptDepth;
    Hashtable theYaccErrors = null;

    protected VWExprEmit() {
    }

    public VWExprEmit(IFieldCollection newFields, IFieldCollection newInheritedFields, IFieldCollection newAltFields, IFieldCollection newAltInheritedFields, Lexer theLexer, Hashtable yaccErrors, VWCompiledExpr outExpr) {
        this.theFields = newFields;
        this.theInheritedFields = newInheritedFields;
        this.theAltFields = newAltFields;
        this.theAltInheritedFields = newAltInheritedFields;
        this.myLexer = theLexer;
        this.theYaccErrors = yaccErrors;
        this.compExpr = outExpr;
    }

    public void setLexer(Lexer theLexer) {
        this.myLexer = theLexer;
    }

    public void setYaccErrors(Hashtable yaccErrors) {
        this.theYaccErrors = yaccErrors;
    }

    public boolean gotError() {
        return this.bGotError;
    }

    public boolean wasIdentTokenBad() {
        return this.bBadIdentToken;
    }

    public void setResultDataType(int resultType, boolean tempDataType) {
        this.theResultDataType = resultType;
        this.tempResultType = tempDataType;
        this.theResultIsArray = this.isArray(resultType);
        switch (resultType) {
            case -3: {
                this.theResultDataType = 1;
                break;
            }
            case -9: {
                this.theResultDataType = 4;
                break;
            }
            case -5: {
                this.theResultDataType = 2;
                break;
            }
            case -8: {
                this.theResultDataType = 16;
                break;
            }
            case -6: {
                this.theResultDataType = 32;
                break;
            }
            case -7: {
                this.theResultDataType = 64;
                break;
            }
            case -4: {
                this.theResultDataType = 8;
                break;
            }
            case -10: {
                this.theResultDataType = 128;
                break;
            }
            case -11: {
                this.theResultDataType = 512;
                break;
            }
        }
    }

    public int getResultDataType() {
        return this.theResultDataType;
    }

    public boolean getResultIsArray() {
        return this.theResultIsArray;
    }

    public IFieldCollection getFields() {
        return this.theFields;
    }

    public IFieldCollection getInheritedFields() {
        return this.theInheritedFields;
    }

    public IFieldCollection getAltFields() {
        return this.theAltFields;
    }

    public IFieldCollection getAltInheritedFields() {
        return this.theAltInheritedFields;
    }

    int findBestType(int type1, int type2) {
        int newType = type1;
        if (type2 == -2) {
            newType = type2;
        }
        if (type1 != type2 && type1 != -2 && type2 != -2) {
            block0 : switch (type1) {
                case 1: {
                    switch (type2) {
                        case 1: 
                        case 8: {
                            newType = type2;
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -3: {
                    switch (type2) {
                        case -4: 
                        case -3: {
                            newType = type2;
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -4: {
                    switch (type2) {
                        case -4: 
                        case -3: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case 8: {
                    switch (type2) {
                        case 1: 
                        case 8: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -5: {
                    switch (type2) {
                        case -5: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case 2: {
                    switch (type2) {
                        case 2: 
                        case 32: 
                        case 64: 
                        case 128: 
                        case 512: {
                            newType = 2;
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case 512: {
                    switch (type2) {
                        case 2: 
                        case 512: {
                            newType = 2;
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -9: {
                    switch (type2) {
                        case -9: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case 4: {
                    switch (type2) {
                        case 4: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -8: {
                    switch (type2) {
                        case -8: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case 16: {
                    switch (type2) {
                        case 16: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -7: {
                    switch (type2) {
                        case -7: 
                        case -5: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case 64: {
                    switch (type2) {
                        case 2: 
                        case 64: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -6: {
                    switch (type2) {
                        case -6: 
                        case -5: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case 32: {
                    switch (type2) {
                        case 2: 
                        case 32: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -10: {
                    switch (type2) {
                        case -10: 
                        case -5: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case 128: {
                    switch (type2) {
                        case 2: 
                        case 128: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                default: {
                    this.throwBadOperandTypes();
                }
            }
        }
        return newType;
    }

    int emitBestType2(OpCode opCode, int type1, int type2) {
        int bestType = this.findBestType(type1, type2);
        this.compExpr.add(opCode);
        return bestType;
    }

    int findBestNumericType(int type1, int type2) {
        this.checkNumericType(type1);
        return this.findBestType(type1, type2);
    }

    int emitBestNumericType2(OpCode opCode, int type1, int type2) {
        this.checkNumericType(type1);
        return this.emitBestType2(opCode, type1, type2);
    }

    int emitNumericType(OpCode opCode, int type1) {
        this.checkNumericType(type1);
        this.emit(opCode);
        return type1;
    }

    int emitAdd(int type1, int type2) {
        int resultType;
        if (!(type1 != 2 && type1 != 128 && type1 != -2 || type2 != 2 && type2 != 128 && type2 != -2)) {
            this.emit(new OpCode(24));
            resultType = type1 == -2 || type2 == -2 ? -2 : 2;
        } else {
            this.checkNumericType(type1);
            this.checkNumericType(type2);
            resultType = this.emitBestType2(new OpCode(24), type1, type2);
        }
        return resultType;
    }

    int emitSubtract(int type1, int type2) {
        int resultType;
        if (!(type1 != 16 && type1 != -2 || type2 != 16 && type2 != -2 || type1 != type2 && type1 != -2 && type2 != -2)) {
            this.emit(new OpCode(25));
            resultType = type1 == -2 || type2 == -2 ? type1 : 1;
        } else {
            this.checkNumericType(type1);
            this.checkNumericType(type2);
            resultType = this.emitBestType2(new OpCode(25), type1, type2);
        }
        return resultType;
    }

    void checkNumericType(int typeFound) {
        this.checkCompatibleType(1, typeFound);
    }

    void checkCompatibleType(int typeExpected, int typeFound) {
        if (typeFound != typeExpected && typeFound != -2) {
            block0 : switch (typeExpected) {
                case 1: 
                case 8: {
                    switch (typeFound) {
                        case 1: 
                        case 8: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                default: {
                    this.throwBadOperandTypes();
                }
            }
        }
    }

    void addError(VWString theMessage) {
        this.bGotError = true;
        this.theYaccErrors.put(this.theYaccErrors.size(), theMessage);
    }

    void throwBadOperandTypes() {
        if (!this.bAlreadyGotBadOperand) {
            VWString theMessage = new VWString("vw.api.VWExprEmitBadOperand", "Got a bad type for operand(s) in the expression.   Offset: {0}", this.myLexer.fn_getLineOffset());
            this.addError(theMessage);
            this.bAlreadyGotBadOperand = true;
        }
    }

    int emit(OpCode opCode) {
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    int emitType(OpCode opCode, int typeExpected, int typeFound) {
        if (typeFound != typeExpected) {
            switch (typeExpected) {
                case 2: {
                    if (typeFound == 64 || typeFound == 32 || typeFound == 128 || typeFound == 512) break;
                    this.throwBadOperandTypes();
                    break;
                }
                default: {
                    this.throwBadOperandTypes();
                }
            }
        }
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    int emitType2(OpCode opCode, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2) {
        if (typeFound1 != typeExpected1 && typeFound1 != -2 && !this.bothStrings(typeFound1, typeExpected1) || typeFound2 != typeExpected2 && typeFound2 != -2 && !this.bothStrings(typeFound2, typeExpected2)) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    public void checkType(int typeExpected, int typeFound) {
        if (typeFound != typeExpected) {
            this.throwBadOperandTypes();
        }
    }

    boolean bothStrings(int X, int Y) {
        return !(X != 2 && X != 32 && X != 64 && X != 128 && X != 512 || Y != 2 && Y != 32 && Y != 64 && Y != 128 && Y != 512);
    }

    int emitType3(OpCode opCode, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2, int typeExpected3, int typeFound3) {
        if (typeFound1 != typeExpected1 && typeFound1 != -2 && !this.bothStrings(typeFound1, typeExpected1) || typeFound2 != typeExpected2 && typeFound2 != -2 && !this.bothStrings(typeFound2, typeExpected2) || typeFound3 != typeExpected3 && typeFound3 != -2 && !this.bothStrings(typeFound3, typeExpected3)) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    int emitType4(OpCode opCode, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2, int typeExpected3, int typeFound3, int typeExpected4, int typeFound4) {
        if (typeFound1 != typeExpected1 && typeFound1 != -2 && !this.bothStrings(typeFound1, typeExpected1) || typeFound2 != typeExpected2 && typeFound2 != -2 && !this.bothStrings(typeFound2, typeExpected2) || typeFound3 != typeExpected3 && typeFound3 != -2 && !this.bothStrings(typeFound3, typeExpected3) || typeFound4 != typeExpected4 && typeFound4 != -2 && !this.bothStrings(typeFound4, typeExpected4)) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    public int emitStringLit(String str) {
        this.emit(new StringLitOp(str));
        return 2;
    }

    public int emitDoubleLit(Double dbl) {
        this.emit(new DoubleLitOp(dbl));
        return 8;
    }

    public int emitNumberLit(Integer i) {
        this.emit(new NumberLitOp(i));
        return 1;
    }

    int emitNumericConvertType(OpCode opCode, int typeExpected, int typeFound) {
        this.checkNumericType(typeFound);
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    int emitNumericConvertType2(OpCode opCode, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2) {
        this.checkNumericType(typeFound1);
        this.checkNumericType(typeFound2);
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    int emitNumericConvertType3(OpCode opCode, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2, int typeExpected3, int typeFound3) {
        this.checkNumericType(typeFound1);
        this.checkNumericType(typeFound2);
        this.checkNumericType(typeFound3);
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    int emitNumericConvertType4(OpCode opCode, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2, int typeExpected3, int typeFound3, int typeExpected4, int typeFound4) {
        this.checkNumericType(typeFound1);
        this.checkNumericType(typeFound2);
        this.checkNumericType(typeFound3);
        this.checkNumericType(typeFound4);
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    int emitBestResult2(OpCode opCode, int type1, int type2) {
        this.emitBestType2(opCode, type1, type2);
        return opCode.getOpCodeValue();
    }

    int emitTrim(int opCodeVal1, int opCodeVal2, int typeFound1, int typeFound2) {
        if (typeFound1 != 2 && typeFound1 != 512 && typeFound1 != -2 || typeFound2 != 2 && typeFound2 != -2 && typeFound2 != -1) {
            this.throwBadOperandTypes();
        }
        OpCode opCode = new OpCode(typeFound2 == -1 ? opCodeVal1 : opCodeVal2);
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    int emitOptType2(OpCode opCode1, OpCode opCode2, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2) {
        if (typeFound1 != typeExpected1 && typeFound1 != -2 || typeFound2 != typeExpected2 && typeFound2 != -2 && typeFound2 != -1) {
            this.throwBadOperandTypes();
        }
        int resultType = opCode1.getOpCodeValue();
        if (typeFound2 != -1) {
            this.compExpr.add(opCode1);
        } else {
            this.compExpr.add(opCode2);
        }
        return resultType;
    }

    int emitOptTimeType2(OpCode opCode1, OpCode opCode2, int typeFound1, int typeExpected2, int typeFound2) {
        if (typeFound1 != 16 && typeFound1 != -2 && typeFound1 != 2 || typeFound2 != typeExpected2 && typeFound2 != -2 && typeFound2 != -1) {
            this.throwBadOperandTypes();
        }
        int resultType = opCode1.getOpCodeValue();
        if (typeFound2 != -1) {
            this.compExpr.add(opCode1);
        } else {
            this.compExpr.add(opCode2);
        }
        return resultType;
    }

    int emitTime2(OpCode opCode, int typeFound1, int typeFound2) {
        if (typeFound1 != 16 && typeFound1 != -2 || typeFound2 != 16 && typeFound2 != -2) {
            this.throwBadOperandTypes();
        }
        if (typeFound1 != -2 && typeFound2 != -2 && typeFound1 != typeFound2) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    int emitTimeNum2(OpCode opCode, int typeFound1, int typeFound2) {
        this.checkNumericType(typeFound2);
        if (typeFound1 != 16 && typeFound1 != -2) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(opCode);
        return opCode.getOpCodeValue();
    }

    int emitDateTimeNum2(OpCode opCode, int typeFound1, int typeFound2) {
        this.checkNumericType(typeFound2);
        if (typeFound1 != 16 && typeFound1 != -2) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(opCode);
        return typeFound1;
    }

    int emitWeekDay(int typeFound) {
        if (typeFound != 16 && typeFound != -2) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(new OpCode(65));
        return 1;
    }

    int emitStrIns(int typeFound1, int typeFound2, int typeFound3) {
        this.checkNumericType(typeFound3);
        if (typeFound1 != 2 && typeFound1 != 512 && typeFound1 != -2 || typeFound2 != 2 && typeFound2 != 512 && typeFound2 != -2) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(new OpCode(35));
        return 2;
    }

    int emitSubStr(int typeFound1, int typeFound2, int typeFound3) {
        this.checkNumericType(typeFound2);
        if (typeFound3 != -1) {
            this.checkNumericType(typeFound3);
        }
        if (typeFound1 != 2 && typeFound1 != 512 && typeFound1 != -2) {
            this.throwBadOperandTypes();
        }
        if (typeFound3 != -1) {
            this.compExpr.add(new OpCode(82));
        } else {
            this.compExpr.add(new OpCode(37));
        }
        return 2;
    }

    int emitRepeat(int typeFound1, int typeFound2) {
        this.checkNumericType(typeFound2);
        if (typeFound1 != 2 && typeFound1 != 512 && typeFound1 != -2) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(new OpCode(44));
        return 2;
    }

    int emitNumberToString(int typeFound1, int typeFound2) {
        this.checkNumericType(typeFound1);
        if (typeFound2 != 2 && typeFound2 != -2 && typeFound2 != -1) {
            this.throwBadOperandTypes();
        }
        if (typeFound2 != -1) {
            this.compExpr.add(new OpCode(56));
        } else {
            this.compExpr.add(new ConvertOp(51, 2, false, 0));
        }
        return 2;
    }

    int emitDaysBetween(int typeFound1, int typeFound2) {
        if (typeFound1 != 16 && typeFound1 != -2 || typeFound2 != 16 && typeFound2 != -2) {
            this.throwBadOperandTypes();
        }
        if (typeFound1 != -2 && typeFound2 != -2 && typeFound1 != typeFound2) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(new OpCode(63));
        return 1;
    }

    int emitIf(int typeFound) {
        if (typeFound != 4 && typeFound != -2) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(new IfOp());
        return this.compExpr.opCount() - 1;
    }

    int emitGoto(int ifOffset) throws Exception {
        this.compExpr.add(new GotoOp());
        this.compExpr.fixupJmp(ifOffset);
        return this.compExpr.opCount() - 1;
    }

    int fixupGoto(int gotoOffset, int typeFound1, int typeFound2) throws Exception {
        this.compExpr.fixupJmp(gotoOffset);
        return this.findBestType(typeFound1, typeFound2);
    }

    int emitFieldDefined1(int opCode, int type1) {
        if (type1 != 2 && type1 != -2) {
            this.throwBadOperandTypes();
        }
        this.compExpr.add(new MiscellaneousOp(opCode));
        return 4;
    }

    int emitFieldDefined2(int type1, int type2) {
        if (type1 != -2 || type2 != 2 && type2 != -2) {
            this.throwBadOperandTypes();
        }
        return 4;
    }

    int emitIsValid(int type1, int type2) {
        this.emit(new ConvertOp(9, type2, false, 0));
        return 4;
    }

    int emitEnvField(int opCode, int type1, int type2) {
        return type2;
    }

    int emitIdent(String name, boolean isAlt, boolean allowFieldNames) throws VWException {
        int returnType = -1;
        if (!allowFieldNames) {
            this.bBadIdentToken = true;
            VWString theMessage = new VWString("vw.api.VWExprEmitIdentifierNotAllowed", "The expression contains an identifier, \"{0}\", possibly an attempt to reference another field, field references are not allowed in field initialization expressions.", name);
            this.addError(theMessage);
            returnType = -2;
        } else {
            try {
                IField theField = null;
                if (!isAlt) {
                    theField = this.theFields.getField(name);
                    if (theField == null && this.theInheritedFields != null) {
                        theField = this.theInheritedFields.getField(this.myLexer.fn_getIdentToken());
                    }
                } else {
                    theField = this.theAltFields.getField(name);
                    if (theField == null && this.theAltInheritedFields != null) {
                        theField = this.theAltInheritedFields.getField(this.myLexer.fn_getIdentToken());
                    }
                }
                if (theField == null) {
                    if (this.myLexer.fn_getIdentToken().startsWith("F_Corr") && this.myLexer.fn_getIdentToken().length() <= 128) {
                        returnType = 2;
                    } else if (this.myLexer.fn_getIdentToken().startsWith("F_EndPointRef") && this.myLexer.fn_getIdentToken().length() <= 128) {
                        returnType = 2;
                    } else if (this.myLexer.fn_getIdentToken().startsWith("F_MyEndPointRef") && this.myLexer.fn_getIdentToken().length() <= 128) {
                        returnType = 2;
                    } else {
                        returnType = theField.getFieldType();
                        if (theField.isArray()) {
                            returnType = this.getArrayType(returnType);
                        }
                    }
                } else {
                    returnType = theField.getFieldType();
                    if (theField.isArray()) {
                        returnType = this.getArrayType(returnType);
                    }
                }
                this.lastEmittedIdentifierFD = theField;
            }
            catch (Exception e) {
                this.bBadIdentToken = true;
                VWString theMessage = new VWString("vw.api.VWExprEmitInvalidIdentifier", "The field \"{0}\" in the expression is an invalid field name.", name);
                this.addError(theMessage);
                returnType = -2;
            }
        }
        this.emit(new IdentOp(name, isAlt));
        return returnType;
    }

    int emitConvert(int currentType, int resultType, boolean isConst, int dimensions) {
        int result;
        block4: {
            result = resultType;
            int basicType = currentType;
            if (dimensions == 0 && this.isArray(currentType) || dimensions > 0 && !this.isArray(currentType)) {
                VWString theMessage = new VWString("vw.api.VWExprEmitBadConvert", "Got a bad convert type in expression.  Line: {0}  Offset: {1}", this.myLexer.fn_getLineNumber(), this.myLexer.fn_getLineOffset());
                this.addError(theMessage);
            }
            if (dimensions > 0) {
                basicType = this.getBasicTypeForArray(currentType);
                result = this.getArrayType(resultType);
            }
            try {
                OpCode.checkConversion(basicType, resultType, isConst);
            }
            catch (VWException e) {
                String theKey = e.getKey();
                if (theKey.compareTo("vw.api.VWOpCodeBadConvertType") != 0) break block4;
                VWString theMessage = new VWString("vw.api.VWExprEmitBadConvertTypeMessage", "Invalid type: {0}", e.getMessage());
                this.addError(theMessage);
            }
        }
        this.emit(new ConvertOp(51, resultType, isConst, dimensions));
        return result;
    }

    boolean isArray(int elemType) {
        return elemType == -3 || elemType == -9 || elemType == -5 || elemType == -8 || elemType == -6 || elemType == -7 || elemType == -4 || elemType == -11 || elemType == -10;
    }

    int getArrayType(int elemType) {
        int arrayType = elemType;
        if (this.isArray(arrayType)) {
            return arrayType;
        }
        switch (elemType) {
            case 1: {
                arrayType = -3;
                break;
            }
            case 4: {
                arrayType = -9;
                break;
            }
            case 2: {
                arrayType = -5;
                break;
            }
            case 16: {
                arrayType = -8;
                break;
            }
            case 32: {
                arrayType = -6;
                break;
            }
            case 64: {
                arrayType = -7;
                break;
            }
            case 8: {
                arrayType = -4;
                break;
            }
            case 128: {
                arrayType = -10;
                break;
            }
            case 512: {
                arrayType = -11;
                break;
            }
            default: {
                VWString theMessage = new VWString("vw.api.VWExprEmitBadType", "Invalid field type.");
                this.addError(theMessage);
            }
        }
        return arrayType;
    }

    int getBasicTypeForArray(int arrayType) {
        int basicType = arrayType;
        if (!this.isArray(basicType)) {
            return basicType;
        }
        switch (arrayType) {
            case -3: {
                basicType = 1;
                break;
            }
            case -9: {
                basicType = 4;
                break;
            }
            case -5: {
                basicType = 2;
                break;
            }
            case -8: {
                basicType = 16;
                break;
            }
            case -6: {
                basicType = 32;
                break;
            }
            case -7: {
                basicType = 64;
                break;
            }
            case -4: {
                basicType = 8;
                break;
            }
            case -10: {
                basicType = 128;
                break;
            }
            case -11: {
                basicType = 512;
                break;
            }
            default: {
                VWString theMessage = new VWString("vw.api.VWExprEmitBadType", "Invalid field type.");
                this.addError(theMessage);
            }
        }
        return basicType;
    }

    int emitArrayConst(int elemType) {
        return this.getArrayType(elemType);
    }

    void emitBeginSubScript() {
        this.emit(new MiscellaneousOp(2));
        ++this.theSubScriptDepth;
    }

    int emitSubscript(int arrayType, int subDataType) {
        if (!this.isArray(arrayType)) {
            VWString theMessage = new VWString("vw.api.VWExprNotArray", "Identifier must be an array.");
            this.addError(theMessage);
        }
        this.emitNumericConvertType(new MiscellaneousOp(14), 1, subDataType);
        return this.getArrayType(arrayType);
    }

    void emitEndSubScript() {
        --this.theSubScriptDepth;
        this.emit(new MiscellaneousOp(90));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int emitProperty(ArrayList props) {
        block20: {
            try {
                if (this.lastEmittedIdentifierFD != null && !this.wasIdentTokenBad()) break block20;
                VWString theMessage = new VWString("vw.api.VWExprPropertyBadIdentifier", "Property cannot be used with a field that is a bad identifier. Ensure the field name in the expression is correct.");
                this.addError(theMessage);
                int n = -1;
                Object var9_7 = null;
                if (props != null) {
                    props.clear();
                }
                return n;
            }
            catch (Throwable throwable) {
                block21: {
                    Object var9_9 = null;
                    if (props == null) break block21;
                    props.clear();
                }
                throw throwable;
            }
        }
        if (!(this.lastEmittedIdentifierFD.getFieldType() == 512 || this.lastEmittedIdentifierFD.isArray() && this.lastEmittedIdentifierFD.getFieldType() == 512)) {
            VWString theMessage = new VWString("vw.api.VWExprPropertyOnGuidOnly", "The property was used incorrectly. This property cannot be used for a field that is not a guid type (VWFieldType.FIELD_TYPE_GUID). Ensure the relevant field is a guid.");
            this.addError(theMessage);
        }
        String fieldName = "";
        try {
            fieldName = this.lastEmittedIdentifierFD.getName();
        }
        catch (Exception e) {
            // empty catch block
        }
        String propertyName = (String)props.get(0);
        if (!fieldName.equals("F_CaseFolder") && !fieldName.equals("F_CaseTask")) {
            VWString theMessage = new VWString("vw.api.VWExprPropertyOnTwoGuidsOnly", "The property {0}.{1} was used incorrectly. Properties can only be used on the F_CaseFolder and F_CaseTask fields.", fieldName, propertyName);
            this.addError(theMessage);
        }
        int returnType = -1;
        CEObjectInfo ceObjInfo = this.lastEmittedIdentifierFD.getCEObjectInfo();
        if (ceObjInfo != null) {
            VWString theMessage;
            if (!ceObjInfo.hasPropertyType(propertyName)) {
                theMessage = new VWString("vw.api.VWExprPropertyPropertyNotFound", "The property {0}.{1} does not exist in the CE object.", fieldName, propertyName);
                this.addError(theMessage);
            } else {
                returnType = ceObjInfo.getPropertyType(propertyName);
                if (returnType != -1 && ceObjInfo.getPropertyIsArray(propertyName)) {
                    returnType = this.getArrayType(returnType);
                }
                if (returnType == -1) {
                    theMessage = new VWString("vw.api.VWExprPropertyBadType", "The property named {0}.{1} in the CE object has an unsupported data type. Only integer, sting, double, date and boolean types are allowed for properties accessed throough the PE.", fieldName, propertyName);
                    this.addError(theMessage);
                }
            }
            this.emit(new PropertyOp(props));
        } else {
            VWGuid reqClass = null;
            try {
                if (this.lastEmittedIdentifierFD instanceof VWFieldDefinition) {
                    reqClass = ((VWFieldDefinition)this.lastEmittedIdentifierFD).getRequiredClass();
                }
            }
            catch (VWException e) {
                // empty catch block
            }
            if (reqClass == null || reqClass.isUndefined()) {
                VWString theMessage = new VWString("vw.api.VWExprPropertyNoCEEngineObjectBecauseNoRequiredClass", "The type of the property named {0}.{1} cannot be resolved because the required class has not been set for the field {0}.", fieldName, propertyName);
                this.addError(theMessage);
            } else {
                VWString theMessage = new VWString("vw.api.VWExprPropertyNoCEEngineObject", "The type of the property named {0}.{1} cannot be resolved because the CE EngineObject is not available.", fieldName, propertyName);
                this.addError(theMessage);
            }
        }
        int n = returnType;
        Object var9_8 = null;
        if (props != null) {
            props.clear();
        }
        return n;
    }
}

